package memory

import (
	"testing"

	"code.justin.tv/extensions/configuration/services/main/data/model/bad"
	"github.com/stretchr/testify/assert"
)

func TestDeletionMarkedPromise(t *testing.T) {
	t.Run("should forward input values", func(t *testing.T) {
		p := newBlockPromise(false, nil)
		assert.False(t, p.WouldBlock())

		val, err := p.Get()
		assert.Equal(t, false, val)
		assert.NoError(t, err)

		marked, err := p.Active()
		assert.False(t, marked)
		assert.NoError(t, err)

		p = newBlockPromise(true, nil)
		val, err = p.Get()
		assert.Equal(t, true, val)
		assert.NoError(t, err)

		marked, err = p.Active()
		assert.True(t, marked)
		assert.NoError(t, err)

		p = newBlockPromise(true, bad.ErrExpected)
		val, err = p.Get()
		assert.Equal(t, true, val)
		assert.Equal(t, bad.ErrExpected, err)

		marked, err = p.Active()
		assert.True(t, marked)
		assert.Equal(t, bad.ErrExpected, err)
	})
}
