package memory

import (
	"testing"

	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/data/model/bad"
	"code.justin.tv/extensions/configuration/services/main/data/model/harness"
	"code.justin.tv/gds/gds/golibs/uuid"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

type mockUUID struct{}

var _ uuid.Source = (*mockUUID)(nil)

func (*mockUUID) Next() (string, error) { return "", bad.ErrExpected }

var newTracker = func(uuid uuid.Source) model.BlockTracker { return New(uuid) }
var newStore = func(uuid uuid.Source) (model.Store, model.BlockTracker) {
	out := New(uuid)
	return out, out
}

func TestStore(t *testing.T) {
	harness.Store{}.RunTests(newStore, true, t)
	harness.BlockTracker{}.RunTests(newTracker, true, t)

	t.Run("should forward serialization failures", func(t *testing.T) {
		store := New(uuid.NewSource()).(*store)
		co := model.NewCommon("env", "extID")
		ch := model.NewChannel("env", "extID", "chID")
		require.NoError(t, store.SaveCommon(co))
		require.NoError(t, store.SaveChannel(ch))
		store.clone = func(_, _ interface{}) error { return bad.ErrExpected }
		var i interface{}
		i, err := store.LoadCommon("env", "extID")
		assert.Nil(t, i)
		assert.Equal(t, bad.ErrExpected, err)
		i, err = store.LoadChannel("env", "extID", "chID")
		assert.Nil(t, i)
		assert.Equal(t, bad.ErrExpected, err)
		assert.Equal(t, bad.ErrExpected, store.SaveCommon(co))
		assert.Equal(t, bad.ErrExpected, store.SaveChannel(ch))
	})

	t.Run("should forward uuid failures", func(t *testing.T) {
		store := New(&mockUUID{})
		co := model.NewCommon("env", "extID")
		ch := model.NewChannel("env", "extID", "chID")
		assert.Equal(t, bad.ErrExpected, store.SaveCommon(co))
		assert.Equal(t, bad.ErrExpected, store.SaveChannel(ch))
	})
}
