package model

import (
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/cache"
)

type RecordPromise interface {
	cache.Promise
	Record() (*protocol.Address, *protocol.Record, error)
}

type MultiRecordPromise interface {
	cache.Promise
	ForSegment(segment protocol.SegmentType) RecordPromise
}

type CommonPromise interface {
	MultiRecordPromise
	Common() (*Common, error)
}

type ChannelPromise interface {
	MultiRecordPromise
	Channel() (*Channel, error)
}

type BlockPromise interface {
	cache.Promise
	Active() (bool, error)
}
