package shared

import (
	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/cache"
)

type BaseChannelPromise interface {
	cache.Promise
	Channel() (*model.Channel, error)
}

type channelPromise struct {
	BaseChannelPromise
}

var _ model.ChannelPromise = (*channelPromise)(nil)

func ChannelPromise(p BaseChannelPromise) model.ChannelPromise { return &channelPromise{p} }

func (c *channelPromise) ForSegment(s protocol.SegmentType) model.RecordPromise {
	return &recordPromise{c, s}
}

func (c *channelPromise) find(s protocol.SegmentType) (*protocol.Address, *protocol.Record, error) {
	channel, err := c.Channel()
	if channel == nil || err != nil {
		return nil, nil, err
	}
	switch s {
	case protocol.BroadcasterType:
		segment, err := protocol.Broadcaster(channel.ChannelID)
		if err != nil {
			return nil, nil, err
		}
		addr := segment.Address(channel.ExtensionID)
		return &addr, channel.Broadcaster, nil
	case protocol.DeveloperType:
		segment, err := protocol.Developer(channel.ChannelID)
		if err != nil {
			return nil, nil, err
		}
		addr := segment.Address(channel.ExtensionID)
		return &addr, channel.Developer, nil
	default:
		return nil, nil, protocol.ErrIllegalSegmentChannel(s, channel.ChannelID)
	}
}
