package shared

import (
	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/cache"
)

type BaseCommonPromise interface {
	cache.Promise
	Common() (*model.Common, error)
}

type commonPromise struct {
	BaseCommonPromise
}

var _ model.CommonPromise = (*commonPromise)(nil)

func CommonPromise(p BaseCommonPromise) model.CommonPromise { return &commonPromise{p} }

func (c *commonPromise) ForSegment(s protocol.SegmentType) model.RecordPromise {
	return &recordPromise{c, s}
}

func (c *commonPromise) find(s protocol.SegmentType) (*protocol.Address, *protocol.Record, error) {
	common, err := c.Common()
	if common == nil || err != nil {
		return nil, nil, err
	}
	switch s {
	case protocol.GlobalType:
		addr := protocol.Global().Address(common.ExtensionID)
		return &addr, common.Global, nil
	default:
		return nil, nil, protocol.ErrIllegalSegmentChannel(s, "")
	}
}
