package shared

import (
	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/protocol"
)

type searchablePromise interface {
	model.MultiRecordPromise
	find(s protocol.SegmentType) (*protocol.Address, *protocol.Record, error)
}

type recordPromise struct {
	src     searchablePromise
	segment protocol.SegmentType
}

var _ model.RecordPromise = (*recordPromise)(nil)

func (r *recordPromise) WouldBlock() bool { return r.src.WouldBlock() }
func (r *recordPromise) Record() (*protocol.Address, *protocol.Record, error) {
	return r.src.find(r.segment)
}
func (r *recordPromise) Get() (interface{}, error) {
	addr, rec, err := r.Record()
	if err != nil {
		return nil, err
	}
	if addr == nil {
		return protocol.RecordMap{}, nil
	}
	return protocol.RecordMap{*addr: rec}, nil
}
