package model

const DefaultEnvironment = "default"

// Store is a StoreFuncs that is capable of being reset
type Store interface {
	StoreFuncs
	Resetable
}

// StoreWithTracker is a common interface for a resetable storage system that
// implements both StoreFuncs and BlockTrackerFuncs
type StoreWithTracker interface {
	StoreFuncs
	BlockTrackerFuncs
	Resetable
}

// StoreFuncs describes the ability to load and save configuration segments
type StoreFuncs interface {
	AsyncLoadCommon(envirionment, extensionID string) CommonPromise
	AsyncLoadChannel(environment, extensionID, channelID string) ChannelPromise

	LoadCommon(environment, extensionID string) (*Common, error)
	LoadChannel(environment, extensionID, channelID string) (*Channel, error)

	SaveCommon(g *Common) error
	SaveChannel(c *Channel) error
	DeleteChannel(channelID string) error

	MarkCommonPublished(g *Common) error
	MarkChannelPublished(c *Channel) error
}
