package data

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/protocol"
)

type nullManager struct{}

func (n *nullManager) WithContext(ctx context.Context) ConfigurationManager { return n }

func (*nullManager) Get(addresses ...protocol.Address) (protocol.RecordMap, error) {
	return nil, protocol.ErrUnimplemented
}

func (*nullManager) GetByChannel(channelID string, includeCommon bool, extensionIDs ...string) (protocol.RecordMap, error) {
	return nil, protocol.ErrUnimplemented
}

func (*nullManager) ForExtension(extensionID string) (ExtensionConfiguration, error) {
	return nil, protocol.ErrUnimplemented
}

func (*nullManager) DeleteByChannel(channelID string) error {
	return protocol.ErrUnimplemented
}
