package data

import (
	"testing"

	"code.justin.tv/extensions/configuration/services/main/protocol"
	"github.com/stretchr/testify/assert"
)

func TestNullManager(t *testing.T) {
	var m nullManager
	var out interface{}

	out, err := m.Get()
	assert.Nil(t, out)
	assert.Equal(t, protocol.ErrUnimplemented, err)

	out, err = m.GetByChannel("", false)
	assert.Nil(t, out)
	assert.Equal(t, protocol.ErrUnimplemented, err)

	out, err = m.ForExtension("")
	assert.Nil(t, out)
	assert.Equal(t, protocol.ErrUnimplemented, err)

	assert.Equal(t, protocol.ErrUnimplemented, m.DeleteByChannel(""))
}
