package listeners

import (
	"code.justin.tv/extensions/configuration/services/main/protocol/messages"
	"code.justin.tv/gds/gds/golibs/event"
	"code.justin.tv/gds/gds/golibs/event/sns"
	"github.com/aws/aws-sdk-go/service/sns/snsiface"
)

const (
	origin      = "extensions/configuration"
	configEvent = "configuration"
)

var eventBusTopics = []event.Topic{messages.ConfigTopic}

type EventBusListener struct {
	config event.Sender
}

func NewEventBusListener(svc snsiface.SNSAPI, env, configARN string) *EventBusListener {
	return &EventBusListener{sns.NewSender(svc, configARN, map[string]string{
		"origin":      origin,
		"environment": env,
		"event":       configEvent,
	})}
}

func (e *EventBusListener) GetTopics() []event.Topic { return eventBusTopics }
func (e *EventBusListener) OnMessages(msgs []event.Message) error {
	for _, msg := range msgs {
		if err := e.config.Send(msg); err != nil {
			return err
		}
	}
	return nil
}
