package protocol

import (
	"encoding/json"
	"testing"

	"code.justin.tv/gds/gds/golibs/errors"
	"github.com/stretchr/testify/assert"
)

func TestRecordMapToPublicReturn(t *testing.T) {
	content := "blah"
	t.Run("correctly maps valid items", func(t *testing.T) {
		r0 := RecordMap{
			Address{
				ExtensionID: "testid",
				SegmentType: BroadcasterType,
				ChannelID:   "testChannel",
			}: NewRecord("blaaaaah", &content),
		}
		pub, err := RecordMapToPublicReturn(r0)
		assert.Nil(t, err)
		bytes, err := json.Marshal(pub)

		assert.Nil(t, err)
		assert.Equal(t, `{"broadcaster:testChannel":{"segment":{"segment_type":"broadcaster","channel_id":"testChannel"},"record":{"content":"blah","version":"blaaaaah"}}}`, string(bytes))
	})

	t.Run("correctly reports invalid items", func(t *testing.T) {
		r0 := RecordMap{
			Address{
				ExtensionID: "extID",
				SegmentType: SegmentType("???"),
				ChannelID:   "testChannel",
			}: NewRecord("1", &content),
		}

		pub, err := RecordMapToPublicReturn(r0)
		assert.Nil(t, pub)
		assert.Equal(t, ErrUnknownSegmentTypeCode, errors.GetErrorCode(err))
	})
}
