package protocol

type SetConfigurationInput struct {
	Address Address
	Record  *Record
}

type SetChannelConfigurationInput struct {
	ChannelID   string  `json:"channel_id"`
	ExtensionID string  `json:"extension_id"`
	Developer   *Record `json:"developer,omitempty"`
	Broadcaster *Record `json:"broadcaster,omitempty"`
}

type SetConfigurationInputV2 struct {
	Address  Address
	Record   *Record
	ExtJwt   string `json:"ext_jwt,omitempty"`
	ClientId string `json:"client_id,omitempty"`
	UserID   string `json:"user_id,omitempty"`
}

type SetChannelConfigurationInputV2 struct {
	ChannelID   string  `json:"channel_id"`
	ExtensionID string  `json:"extension_id"`
	Developer   *Record `json:"developer,omitempty"`
	Broadcaster *Record `json:"broadcaster,omitempty"`
	ExtJwt      string  `json:"ext_jwt,omitempty"`
	ClientId    string  `json:"client_id,omitempty"`
	UserID      string  `json:"user_id,omitempty"`
}

type EditConfigurationV2Input struct {
	ExtJwt   string `json:"ext_jwt,omitempty"`
	ClientId string `json:"client_id,omitempty"`
	UserID   string `json:"user_id,omitempty"`
}
