package cache

import "sync"

type SimplePromise struct {
	hasSet bool
	data   interface{}
	err    error
	loaded sync.WaitGroup
}

func NewPromise() *SimplePromise {
	p := &SimplePromise{}
	p.loaded.Add(1)
	return p
}

func (s *SimplePromise) WouldBlock() bool {
	return !s.hasSet
}

func (s *SimplePromise) Get() (interface{}, error) {
	s.loaded.Wait()
	return s.data, s.err
}

func (s *SimplePromise) Set(data interface{}, err error) *SimplePromise {
	s.hasSet = true
	s.data = data
	s.err = err
	s.loaded.Done()
	return s
}
