package cache

// Source is designed to allow any data model to sit behind a Local
// instance and provide on-demand value retrieval.  The function will be called
// from a goroutine and must be thread safe.
type Source func(key string) (interface{}, error)

// AsyncSource allows custom behavior for dispatching aysnchonrous requests.
type AsyncSource func(key string) Promise
