package config

// Checksum holds a value that can be used to determine if a Config has changed
import (
	"crypto/md5"
	"fmt"
	"reflect"
	"sort"
	"strings"

	"code.justin.tv/gds/gds/golibs/config/sources"
)

// over time.
type Checksum []byte

// Equals returns whether two Checksums are equivalent
func (c Checksum) Equals(other Checksum) bool {
	return reflect.DeepEqual(c, other)
}

func buildChecksum(prefix string, sources []sources.Source) Checksum {
	entries := merge(prefix, sources)
	content := make([]string, 0, len(entries))
	for k, v := range entries {
		content = append(content, prefix+k+"\t"+fmt.Sprintf("%v", v))
	}
	sort.Strings(content)
	data := strings.Join(content, "\n")
	sum := md5.New()
	sum.Write([]byte(data))
	return sum.Sum([]byte{})
}
