package sources

import (
	"os"
)

const environmentRefreshLogicName = "environment"

type environmentRefreshLogic struct {
	vars []string
}

// NewEnvironmentRefreshLogic constructs a RefreshLogic that pulls configuration
// from the os environment
func NewEnvironmentRefreshLogic(vars []string) RefreshLogic {
	return &environmentRefreshLogic{vars}
}

func (e *environmentRefreshLogic) GetName() string { return environmentRefreshLogicName }
func (e *environmentRefreshLogic) GetValues(settings Settings) (Source, error) {
	data := make(map[string]interface{})
	for _, v := range e.vars {
		if val, found := os.LookupEnv(v); found {
			data[v] = val
		}
	}
	return NewStaticSource(e.GetName(), data)
}
