package sources

// Source provides a lookup mechanism for typed variables; the second parameter
// indicates whether the Source contains the key when a zero value is returned
// in the first position. Each source contains a name so that queries about the
// current configuration can display diagnostics about how values have been set.
type Source interface {
	GetName() string
	GetBool(name string) (bool, bool)
	GetFloat(name string) (float64, bool)
	GetInt(name string) (int64, bool)
	GetString(name string) (string, bool)
	GetAll() map[string]interface{}
}

// RefreshableSource extends source with the ability to be refreshed using
// a Config (or other settings object), allowing a source to be polled.
type RefreshableSource interface {
	Source
	Refresh(settings Settings) error
}
