package discovery

import (
	"errors"

	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/service/sts"
)

// GetAccountID returns the AWS account ID associated with the given provider
func GetAccountID(cfg client.ConfigProvider) (string, error) {
	stssrc := sts.New(cfg)
	caller, err := stssrc.GetCallerIdentity(new(sts.GetCallerIdentityInput))
	if err != nil {
		return "", err
	}
	if caller.Account == nil {
		return "", errors.New("Account not found")
	}
	return *caller.Account, nil
}
