package aggregator

import (
	"time"

	"github.com/aws/aws-sdk-go/service/dynamodb"
)

type ReadHandler interface {
	ReturnConsumedCapacity() string
	OnRead(string, time.Duration, ...*dynamodb.ConsumedCapacity)
}

type emptyHandler struct{}

func (*emptyHandler) ReturnConsumedCapacity() string                              { return "NONE" }
func (*emptyHandler) OnRead(string, time.Duration, ...*dynamodb.ConsumedCapacity) {}
