package aggregator

import (
	"sync"

	"github.com/aws/aws-sdk-go/service/dynamodb"
)

type ReadPromise struct {
	tag  string
	data map[string]*dynamodb.AttributeValue
	err  error
	done bool
	wg   sync.WaitGroup
}

func newPromise(tag string) *ReadPromise {
	promise := &ReadPromise{tag: tag}
	promise.wg.Add(1)
	return promise
}

func (r *ReadPromise) set(data map[string]*dynamodb.AttributeValue, err error) {
	r.data = data
	r.err = err
	r.done = true
	r.wg.Done()
}

func (r *ReadPromise) WouldBlock() bool { return !r.done }
func (r *ReadPromise) Get() (interface{}, error) {
	r.wg.Wait()
	return r.data, r.err
}
func (r *ReadPromise) GetData() (map[string]*dynamodb.AttributeValue, error) {
	r.wg.Wait()
	return r.data, r.err
}
