package dynamodb

import (
	"errors"

	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

// Translated dynamo errors
var (
	ErrTooManyRequests = errors.New("Too many requests")
)

func translateDynamoError(err error) error {
	aErr, ok := err.(awserr.Error)
	if ok {
		switch aErr.Code() {
		case dynamodb.ErrCodeProvisionedThroughputExceededException:
			return ErrTooManyRequests
		}
	}
	return err
}
