package lazy

import (
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func cloneAttribute(attr *dynamodb.AttributeValue) *dynamodb.AttributeValue {
	out := new(dynamodb.AttributeValue)
	if attr.B != nil {
		copied := make([]byte, len(attr.B))
		copy(copied, attr.B)
		out.SetB(copied)
	}
	if attr.BOOL != nil {
		out.SetBOOL(*attr.BOOL)
	}
	if attr.BS != nil {
		copied := make([][]byte, len(attr.BS))
		for i, a := range attr.BS {
			if a == nil {
				copied[i] = nil
			} else {
				copied[i] = make([]byte, len(a))
			}
			copy(copied[i], a)
		}
		out.SetBS(copied)
	}
	if attr.L != nil {
		copied := make([]*dynamodb.AttributeValue, len(attr.L))
		for i, a := range attr.L {
			copied[i] = cloneAttribute(a)
		}
		out.SetL(copied)
	}
	if attr.M != nil {
		copied := make(map[string]*dynamodb.AttributeValue)
		for k, v := range attr.M {
			copied[k] = cloneAttribute(v)
		}
		out.SetM(copied)
	}
	if attr.N != nil {
		out.SetN(*attr.N)
	}
	if attr.NS != nil {
		copied := make([]*string, len(attr.NS))
		for i, s := range attr.NS {
			copied[i] = s
		}
		out.SetNS(copied)
	}
	if attr.NULL != nil {
		out.SetNULL(*attr.NULL)
	}
	if attr.S != nil {
		out.SetS(*attr.S)
	}
	return out
}
