package lazy

// MigratableWithMemento enables a struct to customize its serialized form, which
// allows items like implicit datestamp injection but is also necessary to
// explicitly wrap any nested Migratables unless they implement
// Marshaler/Unmarshaler to do it themselves. Any defined migration functions
// are applied to the memento. This is also a potential way to support
// polymorphism by flattening the storage of otherwise unsupported types.
type MigratableWithMemento interface {
	Migratable
	GetMemento() (interface{}, error)
	ApplyMemento(interface{}) error
}
