package errconv

import (
	"code.justin.tv/foundation/twitchclient"
	"github.com/jixwanwang/apiutils"
)

// NewTypeConverter translates from various formats used by gds/gds to the
// golibs/errors/StatusCode definition.
func NewTypeConverter() Converter {
	return FunctionalConverter(func(in error) error {
		switch src := in.(type) {
		case apiutils.ErrorResponse:
			return FromAPIUtils(src)
		case *twitchclient.Error:
			return FromTwitchClient(src)
		default:
			return in
		}
	})
}
