package event

// QueueListener is mostly useful for testing; it holds a FIFO buffer of output
// messages from a coordinator on a given topic list. Naive implementation is
// not threadsafe and will lead to allocations over time.
type QueueListener struct {
	topics   []Topic
	messages []Message
}

func NewQueueListener(topics []Topic) *QueueListener {
	return &QueueListener{topics, []Message{}}
}

func (q *QueueListener) GetTopics() []Topic { return q.topics }
func (q *QueueListener) OnMessages(msgs []Message) error {
	for _, m := range msgs {
		if m.Topic().InSlice(q.topics) {
			q.messages = append(q.messages, m)
		}
	}
	return nil
}

func (q *QueueListener) Get() Message {
	if len(q.messages) == 0 {
		return nil
	}
	msg := q.messages[0]
	q.messages = q.messages[1:]
	return msg
}
