package sns

import (
	"time"

	"code.justin.tv/gds/gds/golibs/event"
)

// From http://docs.aws.amazon.com/lambda/latest/dg/eventsources.html#eventsources-sns
// Read at 2017-11-20

type Record struct {
	EventVersion         string
	EventSubscriptionArn string
	EventSource          string
	Sns                  Message
}

type Message struct {
	Message           string
	MessageAttributes map[string]Attribute
	MessageID         string `json:"MessageId"`
	Signature         string
	SignatureVersion  string
	SigningCertURL    string
	Subject           string
	Timestamp         string
	TopicArn          string
	Type              string
	UnsubscribeURL    string
}

type Attribute struct {
	Type  string
	Value string
}

func NewTestRecord(msg event.Message, snsMessageID string, args map[string]string) (*Record, error) {
	input, err := build(msg, nil, convert(args))
	if err != nil {
		return nil, err
	}
	rec := new(Record)
	rec.EventVersion = "1.0"
	rec.EventSource = "gds:test"
	rec.EventSubscriptionArn = "dummy"
	rec.Sns.SignatureVersion = "1"
	rec.Sns.Signature = "dummy"
	rec.Sns.SigningCertURL = "dummy"
	rec.Sns.Message = *input.Message
	rec.Sns.Timestamp = time.Now().Format(time.RFC3339)
	rec.Sns.MessageID = snsMessageID
	rec.Sns.Type = "Notification"
	rec.Sns.UnsubscribeURL = "dummy"
	rec.Sns.Subject = *input.Subject
	rec.Sns.TopicArn = "dummy"
	rec.Sns.MessageAttributes = make(map[string]Attribute) // only string attributes will be available here
	for k, v := range input.MessageAttributes {
		rec.Sns.MessageAttributes[k] = Attribute{*v.DataType, *v.StringValue}
	}
	return rec, nil
}
