package sns

import (
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/aws/aws-sdk-go/service/sns/snsiface"
)

type MockSNS struct {
	snsiface.SNSAPI
	inputs []*sns.PublishInput
	err    error
}

func NewMockSNS(err error) *MockSNS {
	return &MockSNS{inputs: []*sns.PublishInput{}, err: err}
}

func (d *MockSNS) Publish(input *sns.PublishInput) (*sns.PublishOutput, error) {
	if d.err != nil {
		return nil, d.err
	}
	d.inputs = append(d.inputs, input)
	return &sns.PublishOutput{}, nil
}

func (d *MockSNS) ResetInputs() {
	d.inputs = []*sns.PublishInput{}
}

func (d *MockSNS) SetError(err error) {
	d.err = err
}

func (d *MockSNS) Inputs() []*sns.PublishInput {
	return d.inputs
}
