package event

import "fmt"

var _ error = &UnsupportedFormatVersionError{}

type UnsupportedFormatVersionError struct {
	topic   Topic
	change  Change
	version int
}

func NewUnsupportedFormatVersionError(msg Message) error {
	return &UnsupportedFormatVersionError{msg.Topic(), msg.Change(), msg.FormatVersion()}
}

func (e UnsupportedFormatVersionError) Error() string {
	return fmt.Sprintf("Message type %v, %v version %v is not supported", e.topic, e.change, e.version)
}
