package http

import (
	"context"
	"net/http"

	"code.justin.tv/gds/gds/golibs/metrics"
	"github.com/jixwanwang/apiutils"
)

// ContextCall is designed to return an arbitrary structure for JSON
// serialization on success or a prebult HTTP error on failure; the context should
// pre-populated by the params.Extract middleware.
// DEPRECATED: use APICall and automatic error conversion instead.
type ContextCall func(context.Context) (interface{}, *apiutils.ErrorResponse)

// NewContextHandler creates an adapter around a context call and registers a hystrix
// circuit for the handler.
// DEPRECATED: use NewAPIHandler instead
func NewContextHandler(name string, freq metrics.Frequency, call ContextCall) http.Handler {
	return &APIHandler{adaptContextToAPI(call), name, freq}
}

func adaptContextToAPI(call ContextCall) APICall {
	return func(ctx context.Context) (interface{}, error) {
		obj, err := call(ctx)
		if err == nil {
			return obj, nil
		}
		return obj, *err
	}
}
