package hystrix

import "net/http"

type NamedHandler interface {
	http.Handler
	Name() string
}

type namedHandler struct {
	call http.Handler
	name string
}

func (i *namedHandler) Name() string { return i.name }
func (i *namedHandler) ServeHTTP(w http.ResponseWriter, r *http.Request) {
	i.call.ServeHTTP(w, r)
}

// NameHandler adopts an http.Handler for use with the CreateCircuit middleware
func NameHandler(name string, call http.Handler) http.Handler {
	return &namedHandler{call, name}
}

// NameHandlerFunc adopts an http.HandlerFunc for use with the CreateCircuit middleware
func NameHandlerFunc(name string, f func(w http.ResponseWriter, r *http.Request)) http.Handler {
	return &namedHandler{http.HandlerFunc(f), name}
}
