package infra

import (
	"code.justin.tv/common/config"
)

const (
	appName       = "app-name"
	appEnv        = "app-env"
	componentName = "component-name"
	instanceID    = "instance-id"
)

func init() {
	config.Register(map[string]string{
		appName:       "",
		appEnv:        "development",
		componentName: "",
		instanceID:    "",
	})
}

type InfraConfigProvider interface {
	// AppName returns the application name
	AppName() string

	// AppEnv returns the applications environment
	AppEnv() string

	// ComponentName returns the component name
	ComponentName() string

	// InstanceID returns the instance-id if this is on an AWS instance, blank otherwise
	InstanceID() string
}

// AppName returns the application name inferred from the environment
func AppName() string {
	return config.Resolve(appName)
}

// AppEnv returns the applications environment as inferred from the process environment
func AppEnv() string {
	return config.Resolve(appEnv)
}

// ComponentName returns the component name inferred from the envionment
func ComponentName() string {
	return config.Resolve(componentName)
}

// InstanceID returns the instance-id if this is on an AWS instance, blank otherwise
func InstanceID() string {
	return config.Resolve(instanceID)
}
