package metrics

import (
	"net/http"

	"goji.io/middleware"
)

// Instrument is middleware that uses an Instrumentor to document the request
// using standard parameters; individual routes can override these if they use
// the InstrumentHandler or InstrumentHandlerFunc wrappers at declaration time.
func Instrument(in Instrumentor, defaultName string, defaultFrequency Frequency) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			name := defaultName
			freq := defaultFrequency
			route := middleware.Handler(r.Context())
			if cast, ok := route.(InstrumentedHandler); ok {
				name = cast.Name()
				freq = cast.Frequency()
			}
			wr := &statusWriter{inner: w}
			adapter := NewEventAdapter()
			defer adapter.Complete(&wr.status)
			go in.Instrument(adapter.Wait, name, freq)()
			inner.ServeHTTP(wr, r)
		})
	}
}
