package metrics

import (
	"time"

	"github.com/rcrowley/go-metrics"
)

// Statter defines the stat related functions supported by this implementation
type Statter interface {
	Inc(string, int64)
	Dec(string, int64)
	Timing(string, time.Duration)
}

var _ Statter = (*DimensionRegistry)(nil)

// DimensionRegistry adheres to the statsd.Statter interface. The implementation buffers stats and sends
// them to Cloudwatch every minute
type DimensionRegistry struct {
	registry   metrics.Registry
	dimensions map[string]string
}

// Inc increments the stat by value.
func (c *DimensionRegistry) Inc(stat string, value int64) {
	s := metrics.GetOrRegisterCounter(stat, c.registry)
	s.Inc(value)
}

// Dec decrements the stat by value.
func (c *DimensionRegistry) Dec(stat string, value int64) {
	s := metrics.GetOrRegisterCounter(stat, c.registry)
	s.Dec(value)
}

// Timing adds the delta to the stat.
func (c *DimensionRegistry) Timing(stat string, delta time.Duration) {
	s := metrics.GetOrRegisterTimer(stat, c.registry)
	s.Update(delta)
}
