package mocks

import "io"

type ReaderCloser struct {
	err error
}

func NewReaderCloser(err error) *ReaderCloser {
	return &ReaderCloser{err}
}

func (r *ReaderCloser) Read(p []byte) (int, error) {
	if r.err != nil {
		return 0, r.err
	}
	return 0, io.EOF
}
func (r *ReaderCloser) Close() error { return r.err }
