package mocks

import "net/http"

type ResponseWriter struct {
	body   []byte
	header http.Header
	status int
}

func NewResponseWriter() *ResponseWriter {
	return &ResponseWriter{make([]byte, 0), make(http.Header), 0}
}

func (w *ResponseWriter) Header() http.Header {
	return w.header
}

func (w *ResponseWriter) Write(bytes []byte) (int, error) {
	if len(w.body) == 0 {
		w.body = bytes
	} else {
		w.body = append(w.body, bytes...)
	}
	if w.status == 0 {
		w.status = http.StatusOK
	}
	return len(bytes), nil
}

func (w *ResponseWriter) WriteHeader(status int) {
	w.status = status
}

func (w *ResponseWriter) LastStatus() int {
	return w.status
}

func (w *ResponseWriter) LastWritten() []byte {
	return w.body
}
