package envelopeiface

import "code.justin.tv/systems/sandstorm/internal/envelope"

// Enveloper describes the envelope interface
type Enveloper interface {
	Seal(ctxt map[string]string, plaintext []byte) (EncryptedDataKeys []envelope.EncryptedDataKey, ciphertext []byte, err error)
	Open(EncryptedDataKeys []envelope.EncryptedDataKey, ciphertext []byte, ctxt map[string]string) ([]byte, error)
}
