# Purpose
Daggerfall is the Twitch Extension Entitlement Service. It’s purpose is to be the source of truth for extension entitlements, and will vend two types of data: extension transaction history and entitlements for users. Entitlements can be defined as per channel or per extension, allowing for entitlements that work across channels. It will also allow for extensions to subscribe to notification topics and query Twitch directly, removing many of the communication errors present in extensions today.

## Current State
Currently when a user consumes Bits in an Extension, Payday fires off an event that causes a pubsub notification containing the transaction receipt. This is a one time event, and extension back ends are expected to maintain a record of this event for future use. If an event is lost, there's no way beyond contacting Twitch Support to resolve the loss for the customer or the Extension Developer.


## External RFC
[The external RFC documents how developer can expect to interact with the new entitlement system.](RFC.md)

# Detailed Design

## Design Diagram

## Extension Transactions
This design proposes a new data store for Extension Transactions, which will live in DynamoDB and be accessible through a Visage fronted endpoint. Additionally, this endpoint will be compatible with the [Twitch Websub implementation](https://git-aws.internal.justin.tv/edge/websub#websub). This will allow Developers to subscribe to the notification websub for their extension and be notified directly on any new transaction.

Transactions will be available for listing in two forms:

1. If no pagination is requested, the latest 1000 transactions or the last 7 days (whichever is smaller) will be returned
2. If pagination is specified, 100 transactions are returned

## Entitlement System
In addition to the new Websub, a new Entitlement System will be implemented in the service, that will automatically entitle users to the digital goods associated with each product in Falador. To do so, the Daggerfall worker will additionally inspect each transaction for any benefits defined and attached to the product that was exchanged, and automatically create entries in [HATS](https://git-aws.internal.justin.tv/commerce/hats). These will then be available to developers to list and consume at new Helix endpoints.

### Listing Entitlements
Entitlements will be available to be listed either on a per Extension, or on a per extension, per channel basis. If only the Extension Id is provided when listing the entitlements, all entitlements for that user for that extension, regardless of channel or scope, will be listed in the response. This makes most sense for a back end system that will be operation across many channels.

If the Extension Id and the Channel Id are provided, then the returned entitlements will be only those that are scoped to `Channel` AND were acquired in this channel, as well as all benefits for this extension that are scoped to `Extension`

### Consuming Entitlements
Entitlements are consumed by specifying an Extension Id, User Id, Channel Id, Benefit Id, Quantity and optional metadata string (limited to 255 characters). If all of those pieces of information are correct and available, the following events will happen:
 
 1. The user will be deducted the number of entitlements specified.
 2. A transaction will be created, with a unique transaction Id.
 3. A notification containing the transaction will be fired on the Consumption Websub topic. This notification will contain the metadata provided in the consumption request.
 
The Extension Developer will have 5 minutes to confirm the transaction by the transaction Id, or the transaction will be reversed, and the user will be re-entitled to the benefits consumed.
 

