#!/bin/bash

set -euo pipefail

usage() {
cat <<EOF
Usage: ${0##*/} [-h] DIRNAME BUCKET

Copies bundled CSS and assets in DIRNAME to BUCKET/${PREFIX}. Parses package.json
to determine the major version.

       -h     Display this help and exit
EOF
}

OPTIND=1
PREFIX=ui/
while getopts mh opt; do
	case $opt in
		h)
			usage
			exit 0
			;;
		*)
			usage
			exit 1
			;;
	esac
done
shift $((OPTIND-1))

DIRNAME=$1
BUCKET=$2

if [ -z $BUCKET ]; then
	echo "Error: bucket not specifed"
	usage
	exit 1
fi
if [ -z $DIRNAME ]; then
	echo "Error: directory name not specified"
	usage
	exit 1
fi

VERSION=$(cat package.json | grep version | sed 's/.*"\([0-9]*\).[0-9]*.[0-9]*",/\1/g')

files=$(ls ${DIRNAME}/*.{css,woff,woff2})
for file in $files ; do
	aws s3 cp $file s3://$BUCKET/${PREFIX}v${VERSION}/ --metadata-directive REPLACE --cache-control max-age=60
done