job('extensions-design-system-pr-builder') {
  using 'TEMPLATE-autobuild'
  description('Automatically runs builds against extensions/design-system PRs')
  scm {
    git {
      remote {
        github 'extensions/design-system', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  steps {
    shell 'rm -rf manta-build/'
    shell 'manta -v -f manta/build-prod.json'
  }

  wrappers {
    credentialsBinding {
      // These credentials are provisioned in Jenkins from an IAM user
      // with a narrowly-scoped policy that can send messages to an sns topic,
      // provisioned in prod.
      string('SNS_USER_AWS_ACCESS_KEY_ID', 'gds-jenkins-sns-publisher-access-key-id')
      string('SNS_USER_AWS_SECRET_ACCESS_KEY', 'gds-jenkins-sns-publisher-secret-access-key')
    }
  }
}

job('extensions-design-system-staging-build') {
  using 'TEMPLATE-autobuild'
  description('Builds and deploys the extension design system CSS library for staging')
  scm {
    git {
      remote {
        github 'extensions/design-system', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branch 'main'
      clean true
      configure { node ->
          node / 'extensions' << 'hudson.plugins.git.extensions.impl.SubmoduleOption' {
              recursiveSubmodules true
              timeout 20
        }
      }
    }
  }

  steps {
    shell 'rm -rf manta-build/'
    shell 'manta -v -f manta/build-staging.json'
  }

  wrappers {
    credentialsBinding {
      // These credentials are provisioned in Jenkins from an IAM user
      // with a narrowly-scoped policy that can upload to the staging
      // bucket
      string('AWS_ACCESS_KEY_ID', 'ds-extensions-helper-staging-key')
      string('AWS_SECRET_ACCESS_KEY', 'ds-extensions-helper-staging-secret')
      //
      // These credentials are provisioned in Jenkins from an IAM user
      // with a narrowly-scoped policy that can send messages to an sns topic,
      // provisioned in prod.
      //
      string('SNS_USER_AWS_ACCESS_KEY_ID', 'gds-jenkins-sns-publisher-access-key-id')
      string('SNS_USER_AWS_SECRET_ACCESS_KEY', 'gds-jenkins-sns-publisher-secret-access-key')
    }
  }

  publishers {
    archiveArtifacts{
      pattern('manta-build/*.css,manta-build/*.woff,manta-build/*.woff2')
      onlyIfSuccessful()
      allowEmpty()
    }
    flexiblePublish {
      conditionalAction {
	      condition {
	        status('SUCCESS', 'SUCCESS')
	      }
      }
      steps {
        // Copy to the staging bucket
        shell './deploy.sh manta-build twitch-ds-exthelper-us-west-2-510557735000'
      }
    }
  }
}

job('extensions-design-system-prod-build') {
  description('Builds and deploys the extension design system CSS library for production')

  wrappers {
    credentialsBinding {
      // These credentials are provisioned in Jenkins from an IAM user
      // with a narrowly-scoped policy that can upload to the production
      // bucket
      sshAgent 'git-aws-read-key'
      string('AWS_ACCESS_KEY_ID', 'ds-extensions-helper-prod-key')
      string('AWS_SECRET_ACCESS_KEY', 'ds-extensions-helper-prod-secret')
      //
      // These credentials are provisioned in Jenkins from an IAM user
      // with a narrowly-scoped policy that can send messages to an sns topic,
      // provisioned in prod.
      //
      string('SNS_USER_AWS_ACCESS_KEY_ID', 'gds-jenkins-sns-publisher-access-key-id')
      string('SNS_USER_AWS_SECRET_ACCESS_KEY', 'gds-jenkins-sns-publisher-secret-access-key')
    }
  }

  parameters {
    stringParam 'GIT_TAG'
  }

  scm {
    git {
      remote {
        github 'extensions/design-system', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branch 'refs/tags/\${GIT_TAG}'
      clean true
      configure { node ->
          node / 'extensions' << 'hudson.plugins.git.extensions.impl.SubmoduleOption' {
              recursiveSubmodules true
              timeout 20
        }
      }
    }
  }

  steps {
    shell 'rm -rf manta-build/'
    shell 'manta -v -f manta/build-prod.json'
  }

  publishers {
    archiveArtifacts{
      pattern('manta-build/*.css,manta-build/*.woff,manta-build/*.woff2')
      onlyIfSuccessful()
      allowEmpty()
    }
    flexiblePublish {
      conditionalAction {
	      condition {
	        status('SUCCESS', 'SUCCESS')
	      }
      }
      steps {
        // Copy to the production bucket
        shell './deploy.sh manta-build twitch-ds-exthelper-us-west-2-523543649671'
      }
    }
  }
}