const path = require("path");
const { CleanWebpackPlugin } = require("clean-webpack-plugin");
const CopyWebpackPlugin = require("copy-webpack-plugin");
const MiniCssExtractPlugin = require("mini-css-extract-plugin");
const OptimizeCSSAssetsPlugin = require("optimize-css-assets-webpack-plugin");
const TerserPlugin = require("terser-webpack-plugin");

const buildPath = path.resolve(__dirname, "dist");

module.exports = {
    entry: {
        "twitch-ui": ["./src/index.js", "./src/styles/twitch-ui.scss"],
    },
    output: {
        path: buildPath,
    },
    resolve: {
        alias: {
            "twitch-core-ui-tokens": path.join(__dirname, "node_modules/twitch-core-ui-tokens"),
            "twitch-core-ui-fonts": path.join(__dirname, "node_modules/twitch-core-ui-fonts"),
            "twitch-core-ui": path.join(__dirname, "node_modules/twitch-core-ui/module-scss"),
        }
    },
    module: {
        rules: [
            {
                test: [
                  /\.(svg|eot|ttf|woff|woff2|otf)$/,
                ],
                type: "javascript/auto",
                loader: "file-loader",
                options: {
                  name: "[name].[ext]",
                },
            },
            {
                test: /\.s?[ca]ss$/,
                use: [
                    //process.env.NODE_ENV !== "production" ? "style-loader" : MiniCssExtractPlugin.loader,
                    MiniCssExtractPlugin.loader,
                    { loader: "css-loader", options: { importLoaders: 2 } },
                    {
                        loader: "postcss-loader", options: {
                            postcssOptions: {
                                plugins: [
                                    require("tailwindcss")("./tailwind.config.js"),
                                    require("autoprefixer")({ remove: false }),
                                ],
                            }
                        },
                    },
                    {
                        loader: "sass-loader", options: {
                            implementation: require("sass"),
                            sassOptions: {
                                includePaths: ["node_modules/twitch-core-ui/"],
                            },
                        },
                    }
                ]
            },
        ],
    },
    optimization: {
        minimizer: [

            new TerserPlugin({
                terserOptions: {
                    output: {
                        comments: false,
                    },
                },
                parallel: true,
                sourceMap: true,
            }),
            new OptimizeCSSAssetsPlugin({
                cssProcessorOptions: {
                    autoprefixer: { disable: true },
                    discardComments: { removeAll: true },
                    parser: require("postcss-safe-parser"),
                },
            }),
        ]
    },

    plugins: [
        new CleanWebpackPlugin({
            cleanOnceBeforeBuildPatterns: [buildPath],
        }),
        new CopyWebpackPlugin({
            patterns: [
                {
                    from: "public/",
                    to: buildPath,
                },
            ]
        }
        ),
        new MiniCssExtractPlugin({
            filename: "[name].css",
        }),
    ],

    devServer: {
        open: true,
        contentBase: path.resolve(__dirname, "public"),
        watchContentBase: true,
    },
};