exports.handler = (event, context, callback) => {
 	const request = event.Records[0].cf.request;

    console.log(JSON.stringify(request));
    const originMatcher = new RegExp('https://(.*)\.ext-twitch-exp\.internal\.justin.tv$');
    const originMatch = request.headers['origin'][0].value.match(originMatcher);
	const extId = originMatch[1] || '';

    const pathMatcher = new RegExp('/([^/]+)/(.*)$');
    const pathMatch = request.uri.match(pathMatcher)
	const uriExtId = pathMatch[1] || '';
    const extPath = pathMatch[2] || '';

    const s3DomainName = 'twitch-ds-developer-assets-us-west-2-staging.s3.amazonaws.com';

    request.origin = {
        s3: {
            domainName: s3DomainName,
            region: '',
            authMethod: 'none',
            customHeaders: {}
        }
    };
    request.headers['host'] = [{ key: 'host', value: s3DomainName }];
    request.uri = `/${extId}/${extPath}`;
    callback(null, request);
};
