exports.handler = (event, context, callback) => {
    const request = event.Records[0].cf.request;

    const pathMatcher = new RegExp('/([^/]+)/(.*)$');
    const match = request.uri.match(pathMatcher)
	const uriExtId = match[1];

    const extAssetDomain = `https://${uriExtId}.ext-twitch-exp.internal.justin.tv`;
    const response = event.Records[0].cf.response;
    const cspStr = `connect-src https: wss:; default-src 'self' ${extAssetDomain}; block-all-mixed-content; img-src * data: blob:; media-src * data: blob:; font-src ${extAssetDomain} https://fonts.googleapis.com https://fonts.gstatic.com; style-src 'self' 'unsafe-inline' ${extAssetDomain} https://fonts.googleapis.com; script-src 'self' ${extAssetDomain} https://extension-files.twitch.tv;`;

    response.headers['content-security-policy'] = [{ key: 'Content-Security-Policy', value: cspStr}];
    callback(null, response);
};
