# discovery
Extensions discovery and management service

# Testing locally

`make test`

# Running locally

The discovery service has a hard dependency on RDS, meaning it won't even
start if it can't log into one.  The solution that we came up with for
this is to let it connect directly to the staging or prod RDS.  This is
possible by making use of the teleport-remote enabled bastion host and
some SSH port-forwarding.

## Install teleport-remote on your laptop

Instructions can be found on the wiki.

## SSH to the bastion host with port-forwarding

Here are the bash aliases I have set up to do this.  Run one of these
in a separate terminal window and leave it running in the background.

```
alias discovery-dev='TC=twitch-ext-disco-dev-us-west-2 ssh -L 8443:discovery-nlb-00010538ee0811cf.elb.us-west-2.amazonaws.com:443 -L 5432:discovery.css2xhoreatp.us-west-2.rds.amazonaws.com:5432 jumpbox'
alias discovery-prod='TC=twitch-ext-disco-prod-us-west-2 ssh -L 18443:discovery-nlb-75b155e97db88897.elb.us-west-2.amazonaws.com:443 -L 5433:discovery.clyseqxahisi.us-west-2.rds.amazonaws.com:5432 jumpbox'
```

To connect to dev, run `discovery-dev`.  You can then connect to the
discovery service in dev using:
`curl https://localhost.staging.ext-discovery.us-west-2.internal.justin.tv:8443/debug/running`

To connect to prod, run `discovery-prod`.  You can connect to the discovery
service in prod with:
`curl https://localhost.production.ext-discovery.us-west-2.internal.justin.tv:18443/debug/running`

## Run the service locally, connecting to staging

`AWS_PROFILE=twitch-ext-disco-dev make local`

Once the server has started, you should be able to confirm via

`curl -v http://localhost:8080/debug/running`


# Notes/FAQ

## Optimistic locking
Discovery service does not do optimistic locking for its update APIs (between the select and update part of updates).  This is done for 2 reasons:
1. GORM (http://doc.gorm.io, the ORM used in discovery service) does not support native optimistic locking.  It does have select for update but that is more like queued locking.
2. The rate of writes in discovery service is low and the caller of the write is expected to be the owner of the extension.  Extensions mostly have one owner and don't have much of a usecase to have multiple people making simultaneous changes to the discovery data and so rolling our own optimistic locking seems like overkill at this point.
If or when optimistic locking is needed, the code would probably be something like
```
    var discoveryData model.ExtensionDiscoveryData
    if err := s.db.Where(&model.ExtensionDiscoveryData{
        ExtensionID: reqData.GetExtensionID(),
        Version:     reqData.GetVersion(),
    }).FirstOrCreate(&discoveryData).Error; err != nil {
        // Check for foreign key violation
        if strings.Contains(err.Error(), "violates foreign key constraint") {
            return nil, data.ErrUnregisteredExtension
        }
        // Assumes that all errors here are because the DB was unavailable
        return nil, data.ErrUnavailable
    }

    discoveryData.OptimisticLock++
    s.db.Model(&model.ExtensionDiscoveryData{
        ExtensionID: reqData.GetExtensionID(),
        Version:     reqData.GetVersion(),
    }).
        Where("optimisticVersion = ?", discoveryData.OptimisticLock - 1).
        Save(&discoveryData)
```
(untested; would also need to add the field to the model (setting the default value to zero in the gorm annotation) and probably do a migrate to set those fields to zero on existing records)
