package auth

import (
	discoauth "code.justin.tv/gds/gds/extensions/ems/discoman/auth"
	wauth "code.justin.tv/gds/gds/extensions/whitelist/auth"
)

// Credentials are a per-request interface that can be queried to determine the
// powers that should be granted to a given caller
// TODO should be trimmed (discoauth removed) etc. depending on orchestrator
type Credentials interface {
	wauth.Credentials
	discoauth.Credentials

	HomeChannel() string // will not equal the user in channel editor contexts
	CanAssumeIdentity(userID string) bool

	CanCreateExtensions() bool
	CanInstallAllExtensions() bool
	CanModerateExtensions() bool
	CanReviewExtensions() bool
	CanReviveExtensions() bool
	CanViewAllExtensions() bool
	CanMonetizeExtensions() bool

	CanCreateVersion(extensionID string) bool
	CanEditVersion(extensionID string) bool

	CanInstallInto(channelID string) bool
	CanActivateOn(channelID string) bool
	CanValidateInstall(extensionID string) bool

	CanSkipMobileCheck(extensionID string) bool
}
