package auth

import "net/http"

// Handler is an interface that can get credential associated with a given request
// Different implementations may look at different aspects of the request, eg
// a JWT or a cookie or ...
// Credentials retrieved should be used to check if the calls are authorized
// do perform the requested action
type Handler interface {
	GetCredentials(r *http.Request) (Credentials, error)
}
