These files were copied from code.justin.tv/amzn/TwitchLoggingMiddleware
and modifications were made to include the service name, method name,
and status codes as fields to the json log line for enhanced searchability
in cloudwatch logs.

The contents of stack.go are largely copied from open-source methods for
generating a golang stacktrace from the rollbar library.

Other changes include moving away from the json_logger that the original
TwitchLoggingMiddlewhare used because it wipes out any of the original
structure of the arguments passed to the Log() method by converting them
all to json strings and then embedding them in a json-ified map[string]string,
which makes the embedded structs unsearchable in cloudwatch logs.

Logging is an area where the bootstrap.Logger could improve a great deal,
by coupling more tightly with twirp and taking a context whenever Log()
is called so it could extract the twirp service name and method name
for all log messages to make them searchable.  If twirp has a concept of
a request ID that it puts into the context of every incoming request,
logging that with every log line would make entire transactions searchable.
