package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) AddCategory(ctx context.Context, req *discovery.AddCategoryRequest) (*discovery.AddCategoryResponse, error) {
	err := data.ValidateAddCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	category, err := m.CreateCategory(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.AddCategoryResponse{
		Category: category,
	}, nil
}
