package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
	"code.justin.tv/extensions/discovery/twirputils"
)

func (d *discoveryServer) AddCategoryToExtension(ctx context.Context, req *discovery.AddCategoryToExtensionRequest) (*discovery.AddCategoryToExtensionResponse, error) {
	err := data.ValidateAddCategoryToExtension(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	// First, verify category exists
	cat, err := m.GetCategory(ctx, &discovery.GetCategoryRequest{
		CategoryID: req.GetCategoryID(),
	})
	// Checking for cat being nil should be redundant but might as well be safe
	if err != nil || cat == nil {
		return nil, err
	}

	doc, err := m.AddExtensionToDeveloperCategory(ctx, &discovery.AddExtensionToCategoryRequest{
		CategoryID:  req.GetCategoryID(),
		ExtensionID: req.GetExtensionID(),
		VersionID:   twirputils.WrapString(req.GetVersionID()),
	})
	if err != nil {
		return nil, err
	}

	return &discovery.AddCategoryToExtensionResponse{
		ExtensionCategoryMembership: doc,
	}, nil
}
