package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) AddExtensionToCategory(ctx context.Context, req *discovery.AddExtensionToCategoryRequest) (*discovery.AddExtensionToCategoryResponse, error) {
	err := data.ValidateAddExtensionToCategory(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	category, err := m.GetCategory(ctx, &discovery.GetCategoryRequest{
		CategoryID: req.GetCategoryID(),
		Language:   req.GetLanguage(),
	})
	if err != nil {
		return nil, err
	}

	var resp *discovery.ExtensionCategoryMembershipDocument

	switch category.GetType() {
	case model.CategoryTypeCurated:
		resp, err = m.AddExtensionToCuratedCategory(ctx, req)

	case model.CategoryTypeDeveloper:
		// Developer categories must by added using AddCategoryToExtension
		return nil, data.ErrInvalidCategoryUpdate

	case model.CategoryTypePseudo:
		// Psuedo categories can't have things added to them
		return nil, data.ErrInvalidCategoryUpdate
	}

	if err != nil {
		return nil, err
	}

	return &discovery.AddExtensionToCategoryResponse{
		ExtensionCategoryMembership: resp,
	}, nil
}
