package main

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/manager"
)

func (d *discoveryServer) AddFeaturedCarousel(ctx context.Context, req *discovery.AddFeaturedCarouselRequest) (*discovery.AddFeaturedCarouselResponse, error) {
	err := data.ValidateAddFeaturedCarousel(req)
	if err != nil {
		return nil, err
	}

	m, err := manager.LoadDiscoveryManager(ctx)
	if err != nil {
		return nil, err
	}

	carousel, err := m.CreateFeaturedCarousel(ctx, req)
	if err != nil {
		return nil, err
	}

	return &discovery.AddFeaturedCarouselResponse{
		FeaturedCarousel: carousel,
	}, nil
}
